/*
* Politecnico di Milano
* Corso Informatica Medica 2012/2013 - Prof. Santambrogio
* Esercizi di: Alessandro A. Nacci
* E-mail: alessandro.nacci@mail.polimi.it
* Web: www.alessandronacci.com
* ------------------------------------
*/


/****
*
*	IL PIANO CARTESIANO
*	---------------------------------	
*
*	Un programma per la rappresentaizone tramite metodo BITMAP di forme su un piano cartesiano.
*	Il programmad deve poter rappresentare e visualizzare a schermo forme quali un PUNTO,
*	una LINEA o un QUADRATO.
*
*	Aggiungere la possibilta' di disegnare una funzione descritta polinomio di terzo grado.
*
*	Devono essere presenti inoltre presenti funzioni per la manipolazione e la generazione
*	delle forme create.
*/



#include <stdio.h>
#include <string.h>

// Impostazioni schermo
#define SCREEN_H 20 
#define SCREEN_W 40
#define RISOLUZIONE 800 	//SCREEN_H * SCREEN_W

// Impostazioni memorizzazione
#define MAX_PUNTI_FORMA 64
#define MAX_NUMERO_FORME 10

// Impostazioni sistema
#define LINEE_TERMINALE 25


/*
===============================================
	DEFINIZIONE DEI TIPI DI DATO
===============================================

	Prestare attenzione!
	---------------------------------
	In questa sezione vengono definiti TIPI DI DATO e >> NON << variabili.
	Il tipo di dato rappresenta solo la 'forma' e la 'dimensione in memoria' di una data variabile.
	Il tipo di dato NON contiene alcun valore.

*/


// Elenco delle forme supportate dal programma
typedef enum {F_PUNTO, F_LINEA,
			  F_POLIGONO_QUADRILATERO, F_GENERICA} categoria_forma;			// Elenco delle forme supportate dal programma
typedef enum {D_VERTICALE, D_ORIZZONTALE} direzione;						// Elenco direzioni possibili per le linee

typedef struct {
	int x;
	int y;
	char valore;
} punto_schermo;																	// TIPO DI DATO per la creazione di variabili di tipo 'punto'

typedef struct {
	punto_schermo pixels[MAX_PUNTI_FORMA];											// Elenco dei pixel che compongono la forma
	int numero_pixel;														// Numero dei pixel che compongono la forma
	categoria_forma categoria;												// Categoria della forma
} forma;																	// TIPO DI DATO per la creazione di variabili di tipo 'forma'


/*
===============================================
	PROTOTIPI DELLE FUNZIONI
===============================================
*/

// Funzioni per la visualizzazione a video
void inizializza_schermo(char schermo[SCREEN_W][SCREEN_H]);						// Riempie di caratteri vuoti la matrice in ingresso 'schermo'
void inserisci_bordi(char schermo[SCREEN_W][SCREEN_H]);							// Inserisce il carattere '%' sui bordi della matrice 'schermo'
void disegna_schermo(char schermo[SCREEN_W][SCREEN_H]);							// Disegna a schermo la matrice in ingresso 'schermo'
void aspetta_invio();															// Quando lanciata, mette il programma in attesa di un INVIO da parte dell'utente
void pulisci_terminale();														// Cancella il contenuto del termianale su cui viene stampato l'output del programma

// Modifica delle matriche che rappresenta lo schemo
void disegna_forma(forma f, punto_schermo p, char schermo[SCREEN_W][SCREEN_H]);			// Disegna una data un generica forma 'f' nella posizione 'p' dello schermo 'schermo'
punto_schermo crea_punto_schermo(int x, int y, char valore);							// Resistuisce una variabile strutturata che rapprensenta il punto (x,y) di valore 'valore'

// Generazione delle forme
forma genera_quadrato(int dim, char carattere);									// Restituisce una forma quadrata di lato 'dim'
forma genera_linea(int dim, direzione direzione_linea, char carattere);			// Restituisce una forma linea di lunghezza 'dim'
forma genera_punto(char carattere);												// Restituisce una forma punto (linea di lunghezza 1)
forma genera_polinomio(int a2, int a1, int a0, int dim, char carattere);		// Restituisce la forma che descrive i primi 'dim' punti di un polinomio nella forma y = a2 * x^2 + a1 * x + a0
/*
===============================================
	MAIN
===============================================
*/


int main(){

	char schermo[SCREEN_W][SCREEN_H];
	forma quadrato;
	punto_schermo p;
	forma linea_or;
	forma linea_vr;
	forma punto;


	
	// Disegnamo un quadrato
	inizializza_schermo(schermo);
	pulisci_terminale();

	quadrato = genera_quadrato(4, '#');
	p = crea_punto_schermo(1,1,0);

	disegna_forma(quadrato, p, schermo);
	disegna_schermo(schermo);

	aspetta_invio();


	// Spostiamo il quadrato
	inizializza_schermo(schermo);
	pulisci_terminale();

	quadrato = genera_quadrato(4, '#');
	p = crea_punto_schermo(10,10,0);

	disegna_forma(quadrato, p, schermo);
	disegna_schermo(schermo);

	aspetta_invio();
	

	// Aggiungiamo una linea verticale, una orizzontale ed un punto

	linea_or = genera_linea(9, D_ORIZZONTALE, '#');
	p = crea_punto_schermo(7,1,0);

	disegna_forma(linea_or, p, schermo);
	disegna_schermo(schermo);


	linea_vr = genera_linea(5, D_VERTICALE, '#');
	p = crea_punto_schermo(7,3,0);

	disegna_forma(linea_vr, p, schermo);
	disegna_schermo(schermo);


	punto = genera_punto('#');
	p = crea_punto_schermo(2,2,0);

	disegna_forma(punto, p, schermo);
	disegna_schermo(schermo);

	aspetta_invio();


	// Spostiamo il quadrato
	inizializza_schermo(schermo);
	pulisci_terminale();
	forma polinomio = genera_polinomio(0,-2,0,10,'@');

	p = crea_punto_schermo(0,20,0);

	disegna_forma(polinomio, p, schermo);
	disegna_schermo(schermo);

	aspetta_invio();


}


/*
===============================================
	DEFINIZIONE DELLE FUNZIONI
===============================================
*/


/* Nella prossima lezione */
