/*
* Politecnico di Milano
* Corso Informatica Medica 2012/2013 - Prof. Santambrogio
* Esercizi di: Alessandro A. Nacci
* E-mail: alessandro.nacci@mail.polimi.it
* Web: www.alessandronacci.com
* ------------------------------------
*/


/****
*
*	GESTIONE AUTOMOBILI
*	---------------------------------	
*
*/

#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#define STR_LEN 16
#define MAX_COMP 16

#define MAX_FILE_LINE 256


typedef enum {TRAZIONE, MULTIMEDIA, 
			SICUREZZA} tipi_categoria;

typedef struct {
	int anno_immatricolazione;
	char provincia[STR_LEN];
	int classe_euro;
} libretto_circolazione;

typedef struct {
	char nome[STR_LEN];
	float costo;
	tipi_categoria categoria;
} componente;

typedef struct {
	char nome[STR_LEN];
	float costo;
	char colore[STR_LEN];
	int numero_componenti;
	componente* componenti;
	libretto_circolazione libretto;
} automobile;



void stampa_auto(automobile autovettura);
void stampa_componenti(componente* componenti, int numero_componenti);
automobile crea_auto(char nome[STR_LEN], float costo, char colore[STR_LEN], int numero_componenti, componente* componenti, libretto_circolazione libretto);
componente crea_componente(char nome[STR_LEN], float costo, int categoria);
libretto_circolazione crea_libretto_circolazione(int anno_immatricolazione, char provincia[STR_LEN], int classe_euro);
char* stringa_categoria(tipi_categoria categoria);

automobile modifica_nome_auto(automobile autovettura, char nuovo_nome[STR_LEN]);
void modifica_nome_auto2(automobile autovettura, char nuovo_nome[STR_LEN]);
void modifica_nome_auto3(automobile* autovettura, char nuovo_nome[STR_LEN]);


float calcola_costo_componenti(automobile autovettura);



void scrivi_linea_su_file(char linea[MAX_FILE_LINE], char* nome_file, char* mode);
void salva_auto(automobile autovettura);
void salva_componenti(char* nome_auto, componente* componenti, int numero_componenti);
void salva_libretto_circolazione(char* nome_auto, libretto_circolazione libretto);
automobile carica_automobile(componente* componenti);
void carica_componenti(int numero_componenti, componente* componenti);
tipi_categoria categoria_stringa(char* categoria_str);
libretto_circolazione carica_libretto();

int main () {

	automobile autovettura;
	automobile autovettura_da_file;
	componente componenti[MAX_COMP];
	libretto_circolazione libretto;


	// Creiamo il componente "FRENO"
	componenti[0] = crea_componente("FRENO", 420.20, TRAZIONE);
	componenti[1] = crea_componente("RUOTA", 656.40, TRAZIONE);

	// Creiamo le informazioni del libretto
	libretto = crea_libretto_circolazione(2010, "COMO", 5);

	// Creiamo una autovettura
	autovettura = crea_auto("FIAT_BRAVO", 2000.00, "BLU", 2, componenti, libretto);

	// Stampiamo quello che abbiamo creato
	printf("\nBenvenuto!\n\n\n");
	stampa_auto(autovettura);

	salva_auto(autovettura);

	printf("\n\n\n\n");

	autovettura_da_file = carica_automobile(componenti);
	stampa_auto(autovettura_da_file);

	return 0;
}



libretto_circolazione crea_libretto_circolazione(int anno_immatricolazione, 
						char provincia[STR_LEN], int classe_euro)
{

	libretto_circolazione libretto;
	libretto.anno_immatricolazione = anno_immatricolazione;
	strcpy(libretto.provincia,provincia);
	libretto.classe_euro = classe_euro;

	return libretto;
}


componente crea_componente(char nome[STR_LEN], 
						float costo, int categoria)
{
	componente c;

	strcpy(c.nome, nome);
	c.costo = costo;
	c.categoria = categoria;

	return c;
}

automobile crea_auto(char nome[STR_LEN], float costo, char colore[STR_LEN], 
				int numero_componenti, componente* componenti, 
				libretto_circolazione libretto)
{

	printf("Creo una nuova autovettura di nome: %s\n", nome);

	automobile autovettura;

	strcpy(autovettura.nome,nome);
	autovettura.costo = costo;
	strcpy(autovettura.colore,colore);
	autovettura.numero_componenti = numero_componenti;
	autovettura.componenti = componenti;
	autovettura.libretto = libretto;

	return autovettura;

}

void stampa_libretto_circolazione(libretto_circolazione libretto)
{
	printf("Anno: %d |\t Prov.:%s |\t Euro:%d\n", libretto.anno_immatricolazione, 
					libretto.provincia, libretto.classe_euro);
}

void stampa_componenti(componente* componenti, int numero_componenti)
{
	int i;

	for (i = 0; i < numero_componenti; i++)
	{
		printf("Nome componente: %s |\t Costo: eur. %f |\t Categoria: %s \n", 
				componenti[i].nome, componenti[i].costo, 
				stringa_categoria(componenti[i].categoria));
	}
}

void stampa_auto(automobile autovettura)
{
	printf("Nome: %s\n", autovettura.nome);
	printf("Colore: %s\n", autovettura.colore);
	printf("Costo: eur.%f\n", autovettura.costo);
	printf("Costo componenti: eur. %f \n", calcola_costo_componenti(autovettura) );
	printf("\nCOMPONENTI:\n");
	printf("-----------------------\n");
	stampa_componenti(autovettura.componenti, autovettura.numero_componenti);
	printf("\nLIBRETTO CIRCOLAZIONE:\n");
	printf("-----------------------\n");
	stampa_libretto_circolazione(autovettura.libretto);
}

void scrivi_linea_su_file(char linea[MAX_FILE_LINE], char* nome_file, char* mode)
{
    FILE *fp_mio_file;

	fp_mio_file = fopen (nome_file, mode);
    
    if (fp_mio_file==NULL)
        printf("Si e' verificato un errore nell'apertura del file.\n");
    else 
    	printf("File aperto correttamente.\n");
    

	fprintf(fp_mio_file,"%s",linea);
	
    if (fclose (fp_mio_file)==0)
    	printf("File chiuso correttamente.\n");
}

void salva_auto(automobile autovettura)
{
	char linea[MAX_FILE_LINE];
	sprintf(linea, "%s\t%s\t%f\t%d\n", autovettura.nome, autovettura.colore, 
		autovettura.costo, autovettura.numero_componenti );
	scrivi_linea_su_file(linea, "auto_db", "w"); 	
	salva_componenti(autovettura.nome, autovettura.componenti, 
		autovettura.numero_componenti);
	salva_libretto_circolazione(autovettura.nome, autovettura.libretto);
}

void salva_componenti(char* nome_auto, componente* componenti, int numero_componenti)
{
	int i;
	char linea[MAX_FILE_LINE];

	for (i = 0; i < numero_componenti; i++)
	{
		sprintf(linea,"%s\t%s\t%f\t%s\n", nome_auto, componenti[i].nome, 
			componenti[i].costo, stringa_categoria(componenti[i].categoria));
		scrivi_linea_su_file(linea, "componenti_db", "a");
	}
}

void salva_libretto_circolazione(char* nome_auto, libretto_circolazione libretto)
{
	char linea[MAX_FILE_LINE];
	sprintf(linea, "%s\t%d\t%s\t%d\n", nome_auto, 
			libretto.anno_immatricolazione, libretto.provincia, 
			libretto.classe_euro);
	scrivi_linea_su_file(linea, "libretto_db", "w");
}

automobile carica_automobile(componente* componenti)
{
	FILE *fp_mio_file;
	char nome[STR_LEN];
	char colore[STR_LEN];
	float costo;
	int numero_componenti;
	libretto_circolazione libretto;
    
    fp_mio_file = fopen ("auto_db", "r");
    if (fp_mio_file==NULL)
        printf("Errore apertura file!\n");
    else{
    	fscanf(fp_mio_file, "%s", nome);
    	fscanf(fp_mio_file, "%s", colore);
    	fscanf(fp_mio_file, "%f", &costo);
    	fscanf(fp_mio_file, "%d", &numero_componenti);

    }

    fclose(fp_mio_file);
    carica_componenti(numero_componenti, componenti);
    libretto = carica_libretto();

    automobile autovettura = crea_auto(nome, costo, colore, 
		numero_componenti, componenti, libretto);

    return autovettura;
    
}

void carica_componenti(int numero_componenti, componente* componenti)
{

	FILE *fp_mio_file;


	char nome_auto[STR_LEN];
	char nome[STR_LEN];
	float costo;
	char categoria_str[STR_LEN];
	tipi_categoria categoria;
	int i;

	printf("numero c:%d\n", numero_componenti);

    fp_mio_file = fopen ("componenti_db", "r");
    if (fp_mio_file==NULL)
        printf("Errore apertura file!\n");
    else{

    	for (i = 0; i < numero_componenti; i++)
    	{
	    	fscanf(fp_mio_file, "%s", nome_auto);
	    	fscanf(fp_mio_file, "%s", nome);
	    	fscanf(fp_mio_file, "%f", &costo);
	    	fscanf(fp_mio_file, "%s", categoria_str);
	    	categoria = categoria_stringa(categoria_str);


	    	componenti[i] = crea_componente(nome, costo, categoria);
		}	
    }

    fclose(fp_mio_file);


}

libretto_circolazione carica_libretto()
{
	FILE *fp_mio_file;
	char nome_auto[STR_LEN];
	int anno_immatricolazione;
	char provincia[STR_LEN];
	int classe_euro;


    fp_mio_file = fopen ("libretto_db", "r");
    if (fp_mio_file==NULL)
        printf("Errore apertura file!\n");
    else{
    	fscanf(fp_mio_file, "%s", nome_auto);
    	fscanf(fp_mio_file, "%d", &anno_immatricolazione);
    	fscanf(fp_mio_file, "%s", provincia);
    	fscanf(fp_mio_file, "%d", &classe_euro);

    }

    return crea_libretto_circolazione(anno_immatricolazione, provincia, classe_euro);

}

char* stringa_categoria(tipi_categoria categoria)
{
	if (categoria == TRAZIONE) return "TRAZIONE";
	if (categoria == MULTIMEDIA) return "MULTIMEDIA";
	if (categoria == SICUREZZA) return "SICUREZZA";

	return "SCONOSCIUTO";

}


tipi_categoria categoria_stringa(char* categoria_str)
{


	if (strcmp(categoria_str, "TRAZIONE")) return TRAZIONE;
	if (strcmp(categoria_str, "MULTIMEDIA")) return MULTIMEDIA;
	if (strcmp(categoria_str, "SICUREZZA")) return SICUREZZA;

	printf("Errore conversione categoria! - %s\n", categoria_str);

	return 0;
}


automobile modifica_nome_auto(automobile autovettura, char nuovo_nome[STR_LEN])
{
	strcpy(autovettura.nome, nuovo_nome);
	return autovettura;
}

void modifica_nome_auto2(automobile autovettura, char nuovo_nome[STR_LEN])
{
	strcpy(autovettura.nome, nuovo_nome);
}

void modifica_nome_auto3(automobile* autovettura, char nuovo_nome[STR_LEN])
{

	strcpy(autovettura->nome, nuovo_nome);
}

float calcola_costo_componenti(automobile autovettura)
{
	int i;
	float tot = 0;

	for (i = 0; i < autovettura.numero_componenti; i++)
	{
		tot += autovettura.componenti[i].costo;
	}

	return tot;
}

