#include <stdio.h>
#include <math.h>

#define W 10
#define H 10

#define VALORE_TESORO 15

void stampa_mappa(int mappa[W][H])
{
	int x,y;

	for (x = 0; x < W; x++)
	{
		for (y = 0; y < H; y++)
		{
			printf("%d\t", mappa[x][y]);		
		}
		printf("\n");
	}

	printf("\n\n\n");

}

void stampa_percorso(int mappa[W][H])
{
	int x,y;

	for (x = 0; x < W; x++)
	{
		for (y = 0; y < H; y++)
		{
			if (mappa[x][y] == -1) printf("#\t");
			else printf("-\t");
		}
		printf("\n");
	}

	printf("\n\n\n");

}

void init_mappa(int mappa[W][H])
{

	int x,y;

	for (x = 0; x < W; x++)
	{
		for (y = 0; y < H; y++)
		{
			mappa[x][y] = 0;
		}
	}

}








void metti_tesoro(int mappa[W][H], int tes_x, int tes_y)
{

	int radius;
	int x,y;
	int start_x, start_y;
	int end_x, end_y;

	int val_tesoro = VALORE_TESORO;

	mappa[tes_x][tes_y] = val_tesoro;

	// attenzione alla dimensione massima del raggio!
	for (radius = 1; radius < W; radius++)
	{
		start_x = tes_x - radius;
		start_y = tes_y - radius;

		end_x = tes_x + radius;
		end_y = tes_y + radius;

		for (x = start_x; x <= end_x; x++)
			for (y = start_y; y <= end_y; y++)
				if ( ((x == start_x) || (x == end_x)) || ((y == start_y) || (y == end_y)))
					if (x >= 0 && y >= 0 && x < W && y < H )
						mappa[x][y] = val_tesoro - radius;
	}
}

int cerca_tesoro(int mappa[W][H], int start_x, int start_y)
{
	if (mappa[start_x][start_y] == VALORE_TESORO) return 1;

	int x,y;

	for (x = start_x - 1; x <= start_x + 1; x++)
		for (y = start_y - 1; y <= start_y + 1; y++)
			if (x>0 && y >= 0 && x<W && y<H)
				if (mappa[x][y] > mappa[start_x][start_y])
				{
					mappa[start_x][start_y] = -1;
					return cerca_tesoro(mappa, x, y);
				}

	return 0;
}


int main()
{
	int mappa[W][H];
	int x,y;
	int trovato = 0;

	init_mappa(mappa);
	stampa_mappa(mappa);

	metti_tesoro(mappa, 5,5);
	stampa_mappa(mappa);

	trovato = cerca_tesoro(mappa, 0,2);

	if (trovato) printf("Ho trovato il tesoro!\n");

	stampa_mappa(mappa);
	stampa_percorso(mappa);

}